<?php
require_once('utility.php');
require_once( "/opt/TrendMicro/DTAS/ManagementServer/bin/common.php" ) ;

function getSandboxGroupInfo( $sbGroupsArray, $uuid ) {
    foreach( $sbGroupsArray as $sbGroup ) {
        if( strcasecmp( $sbGroup[ "ID" ], $uuid ) === 0 ) {
            return $sbGroup ;
        }
    }
    return null ;
}

function isSandboxGroupExist( $connection, $sb_vmpath ) {
    $queryResult = pg_query_params(
        $connection,
        "SELECT key FROM tb_global_setting WHERE key LIKE $1 AND value = $2",
        array( "configuration.image_type.image_%.path", $sb_vmpath ) ) ;

    if( $queryResult === false ) {
        throw new Exception( pg_last_error() ) ;
    }
        
    if( pg_fetch_all( $queryResult ) === false ) {
        return false ;
    }
    
    return true ;
}

function getMaxSandboxImageTypeId( $connection ) {
    if( ( $queryResult = pg_query( $connection,
        "SELECT max(value) FROM tb_global_setting WHERE key LIKE 'configuration.image_type.image_%.id'" ) ) == false ) {

        throw new Exception( pg_last_error() ) ;
    }
    
    # empty result => NotExist
    if( ( ( $record = pg_fetch_array( $queryResult, 0, PGSQL_NUM ) ) === false ) ) {
        return 0 ;
    }
    
    return $record[ 0 ] ;
}

function getSandboxImageTypeId( $connection, $sb_vmpath ) {
    $queryResult = pg_query_params( $connection,
                                    "SELECT key FROM tb_global_setting WHERE key LIKE $1 AND value = $2",
                                    array( "configuration.image_type.image_%.path",
                                           $sb_vmpath ) ) ;

    if( $queryResult === false ) {
        throw new Exception( pg_last_error() ) ;
    }
    
    # empty result => NotExist
    if( ( $record = pg_fetch_all( $queryResult ) ) === false ) {
        return 0 ;
    }
    
    # format: 'configuration.image_type.image_1.path'
    $record = pg_fetch_array( $queryResult, 0, PGSQL_NUM ) ;
    $key = $record[ 0 ] ;
    $slices = explode( ".", $key ) ;
    $idAry  = explode( "_", $slices[ 2 ] ) ;
    $id     = $idAry[ 1 ] ;
    return $id ;
}

function getSandboxImageTypeUid( $connection, $sb_vmpath ) {
    $id = getSandboxImageTypeId( $connection, $sb_vmpath ) ;
    if( $id === 0 ) {
        return 0 ;
    }
    
    debug_print( "ImageTypeId: $id" ) ;
    if( ( $queryResult = pg_query_params(
                $connection,
                "SELECT value FROM tb_global_setting WHERE key = $1",
                array( "configuration.image_type.image_$id.image_type_uuid" ) ) ) == false ) {

                    throw new Exception( pg_last_error() ) ;
    }
    
    $record = pg_fetch_array( $queryResult, 0, PGSQL_NUM ) ;
    return $record[ 0 ] ;
}

function getSandboxImagePathVix( $sb_vmpath ) {
    $pathes_esxi = file( $GLOBALS[ "NEW_SB_GROUP_INFO_ESXI_FILE" ] ) ;
    $index = array_search( $sb_vmpath, $pathes_esxi ) ;
    
    $pathes_vix = file( $GLOBALS[ "NEW_SB_GROUP_INFO_VIX_FILE" ] ) ;
    return $pathes_vix[ $index ] ;
}

function stopSpcd() {

    # get service 'spcd' status
    debug_print( "GetScServiceStatus: service='spcd'" ) ;
    $ret_array = run_program_at_sc_by_ssh( array(
        'program'   => "service",
        'arguments' => array( "spcd", "status" ) ) ) ;
    $retCode      = $ret_array[ 0 ] ;
    $stdoutMsgAry = $ret_array[ 1 ] ;
    $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
    if( $retCode != 0 ) {
        $stderrMsgAry = $ret_array[ 2 ] ;
        $stderrMsg    = join( "\n", $stderrMsgAry ) ;
        throw new Exception( "GetScServiceStatusFail: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
    }
    debug_print( "GetScServiceStatusSuccess: $stdoutMsg" ) ;
    
    # using 'Regular Expression' to check status
    $ptn    = '/stopped/i' ;
    $result = preg_match( $ptn, $stdoutMsg, $matches ) ;
    
    # no error occurs and something matched (stopped)
    if( $result !== false && $result !== 0 ) {
        debug_print( "AlreadyStopped: service='spcd', status='$stdoutMsg'" ) ;
        return ;
    }
    
    $ret_array = run_program_at_sc_by_ssh( array(
        'program'   => "service",
        'arguments' => array( "spcd", "stop" ) ) ) ;
    $retCode      = $ret_array[ 0 ] ;
    $stdoutMsgAry = $ret_array[ 1 ] ;
    $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
    if( $retCode != 0 ) {
        $stderrMsgAry = $ret_array[ 2 ] ;
        $stderrMsg    = join( "\n", $stderrMsgAry ) ;
        throw new Exception( "StopSpcdFail: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
    }
    debug_print( "StopSpcdSuccess: $stdoutMsg" ) ;
}

function startSpcd() {
    # get service 'spcd' status
    debug_print( "GetScServiceStatus: service='spcd'" ) ;
    $ret_array = run_program_at_sc_by_ssh( array(
        'program'   => "service",
        'arguments' => array( "spcd", "status" ) ) ) ;
    $retCode      = $ret_array[ 0 ] ;
    $stdoutMsgAry = $ret_array[ 1 ] ;
    $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
    if( $retCode != 0 ) {
        $stderrMsgAry = $ret_array[ 2 ] ;
        $stderrMsg    = join( "\n", $stderrMsgAry ) ;
        throw new Exception( "GetScServiceStatusFail: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
    }
    debug_print( "GetScServiceStatusSuccess: $stdoutMsg" ) ;
    
    # using 'Regular Expression' to check status
    $ptn    = '/running/i' ;
    $result = preg_match( $ptn, $stdoutMsg, $matches ) ;
    
    # no error occurs and something matched (started)
    if( $result !== false && $result !== 0 ) {
        debug_print( "AlreadyStarted: service='spcd', status='$stdoutMsg'" ) ;
        return ;
    }
    
    $ret_array = run_program_at_sc_by_ssh( array(
        'program'   => "service",
        'arguments' => array( "spcd", "start" ) ) ) ;
    $retCode      = $ret_array[ 0 ] ;
    $stdoutMsgAry = $ret_array[ 1 ] ;
    $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
    if( $retCode != 0 ) {
        $stderrMsgAry = $ret_array[ 2 ] ;
        $stderrMsg    = join( "\n", $stderrMsgAry ) ;
        throw new Exception( "StartSpcdFail: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
    }
    debug_print( "StartSpcdSuccess: $stdoutMsg" ) ;
}

function getUsbxStateInfo( $usbxcli ) {
    $ret_array = run_program_at_sc_by_ssh( array(
        'program'   => "/usr/bin/python",
        'arguments' => array( $usbxcli,
                              "sys-getstate" ) ) ) ;
    $retCode = $ret_array[ 0 ] ;
    $msgAry  = $ret_array[ 1 ] ;
    $msg     = join( ", ", $msgAry ) ;
    if( $retCode != 0 ) {
        throw new Exception( "GetUsbxStateFail: ret=$retCode, msg='$msg'" ) ;
    }

    # get usbx 'state' and remove it
    $usbxState = $msgAry[ 0 ] ;
    array_shift( $msgAry ) ;
    
    # concatnate others
    $msg = join( ", ", $msgAry ) ;

    # get usbx 'state id'
    $usbxStateId = null ;
    $ptn    = '/State:\s+(\d+)/i' ;
    $result = preg_match( $ptn, $msg, $matches ) ;
    if( $result !== false && $result !== 0 ) {
        $usbxStateId = isset( $matches[ 1 ] ) ? $matches[ 1 ] : null ;
    }
    
    # get usbx 'msg'
    $usbxMsg = $msg ;
    $ptn = '/msg:(.+)/i' ;
    $result = preg_match( $ptn, $msg, $matches ) ;
    if( $result !== false && $result !== 0 ) {
        $usbxMsg = isset( $matches[ 1 ] ) ? $matches[ 1 ] : null ;
    }
    
    # get usbx 'errCode'
    $usbxErrCode = null ;
    $ptn = '/error\((\d+)\)/i' ;
    $result = preg_match( $ptn, $msg, $matches ) ;
    if( $result !== false && $result !== 0 ) {
        $usbxErrCode = isset( $matches[ 1 ] ) ? $matches[ 1 ] : null ;
    }

    # get usbx 'progress'
    $usbxProgress = null ;
    $ptn = '/\((\d+%)\)/' ;
    $result = preg_match( $ptn, $msg, $matches ) ;
    if( $result !== false && $result !== 0 ) {
        $usbxProgress = isset( $matches[ 1 ] ) ? $matches[ 1 ] : null ;
    }

    # get usbx 'group uid'
    $usbxGrpUid   = null ;    
    $ptn = '/sbxgrp: ([\d\w\W]+)/' ;
    $result = preg_match( $ptn, $msg, $matches ) ;
    if( $result !== false && $result !== 0 ) {
        $usbxGrpUid = isset( $matches[ 1 ] ) ? $matches[ 1 ] : null ;
    }
    
    return array(
        'state'    => $usbxState,
        'stateId'  => $usbxStateId,
        'msg'      => $usbxMsg,
        'errCode'  => $usbxErrCode,
        'progress' => $usbxProgress,
        'groupUid' => $usbxGrpUid ) ;
}

function getUsbxState( $usbxcli ) {
    $ret_array = run_program_at_sc_by_ssh( array(
        'program'   => "/usr/bin/python",
        'arguments' => array( $usbxcli,
                              "sys-getstate" ) ) ) ;
    $retCode     = $ret_array[ 0 ] ;
    $retMsgArray = $ret_array[ 1 ] ;
    $retMsg      = join( ", ", $retMsgArray ) ;
    if( $retCode != 0 ) {
        throw new Exception( "GetUsbxStateFail: ret=$retCode, msg='$retMsg'" ) ;
    }
    
    return strtolower( $retMsgArray[ 0 ] ) ;
}

function getSbxGrpUidByUsbxState( $usbxcli ) {
    $ret_array = run_program_at_sc_by_ssh( array(
        'program'   => "/usr/bin/python",
        'arguments' => array( $usbxcli,
                              "sys-getstate" ) ) ) ;
    $retCode     = $ret_array[ 0 ] ;
    $retMsgArray = $ret_array[ 1 ] ;
    $retMsg      = join( ", ", $retMsgArray ) ;
    if( $retCode != 0 ) {
        throw new Exception( "GetUsbxStateFail: ret=$retCode, msg='$retMsg'" ) ;
    }
    
    if( isset( $retMsgArray[ 2 ] ) == false ) {
        return null ;
    }
    
    $ptn    = '/Msg:\s+(.*)\s\((\d+%)\),.*sbxgrp: (.*)/i' ;
    $result = preg_match( $ptn, $retMsgArray[ 2 ], $matches ) ;
    if( $result === false ) {
        echo "ErrorOccursWhenExtractingSbxGrpUid: msgReturnFromUsbx='" . $retMsgArray[ 2 ] . "', ptn='$ptn'\n" ;
    }
    elseif( $result === 0 ) {
        echo "ExtractNothingFromUsbxMessage: msgReturnFromUsbx='" . $retMsgArray[ 2 ] . "', ptn='$ptn'" ;
    }
    
    if( isset( $matches[ 3 ] ) == false ) {
        return null ;
    }
    
    return $matches[ 3 ] ;
}

function stopUsbx( $usbxcli ) {
    $curStateStr = getUsbxState( $usbxcli ) ;
    debug_print( "UsbxCurrentState='$curStateStr'" ) ;
    
    switch( $curStateStr ) {
    
        # no need to do anything in these two cases
        case "noimage" :
        case "maintenance" :
            return ;
        
        
        case "init" :
            debug_print( "TryToInitUsbx: curState='init'" ) ;
            $ret_array = run_program_at_sc_by_ssh( array(
                'program'   => "/usr/bin/python",
                'arguments' => array( $usbxcli,
                                      "sys-init" ) ) ) ;
            $retCode     = $ret_array[ 0 ] ;
            $retMsgArray = $ret_array[ 1 ] ;
            $retMsg      = join( "\n", $retMsgArray ) ;
            if( $retCode != 0 ) {
                throw new Exception( "InitUsbxFail: ret=$retCode, msg= $retMsg" ) ;
            }
            debug_print( "InitUsbxSuccess" ) ;
            
            break ;
            
        case "running" :
            debug_print( "TryToStopUsbx: curState='running'" ) ;
            $ret_array = run_program_at_sc_by_ssh( array(
                'program'   => "/usr/bin/python",
                'arguments' => array( $usbxcli,
                                      "sys-stop" ) ) ) ;
            $retCode     = $ret_array[ 0 ] ;
            $retMsgArray = $ret_array[ 1 ] ;
            $retMsg      = join( "\n", $retMsgArray ) ;
            if( $retCode != 0 ) {
                throw new Exception( "StopUsbxFail: ret=$retCode, msg= $retMsg" ) ;
            }
            debug_print( "StopUsbxSuccess" ) ;
            
            break ;
    }
    
    $curStateStr = getUsbxState( $usbxcli ) ;
    debug_print( "UsbxCurrentState='$curStateStr'" ) ;
}

function startUsbx( $usbxcli ) {
    $curStateStr = getUsbxState( $usbxcli ) ;
    debug_print( "UsbxCurrentState='$curStateStr'" ) ;
    
    switch( $curStateStr ) {
    
        # no need to do anything in these two cases
        case "noimage" :
        case "running" :
            return ;
        
        case "maintenance" :
            debug_print( "TryToStartUsbx: curState='maintenance'" ) ;
            $ret_array = run_program_at_sc_by_ssh( array(
                'program'   => "/usr/bin/python",
                'arguments' => array( $usbxcli,
                                      "sys-start" ) ) ) ;
            $retCode     = $ret_array[ 0 ] ;
            $retMsgArray = $ret_array[ 1 ] ;
            $retMsg      = join( "\n", $retMsgArray ) ;
            if( $retCode != 0 ) {
                throw new Exception( "StartUsbxFail: ret='$retCode', msg='$retMsg'" ) ;
            }
            debug_print( "StartUsbxSuccess" ) ;
            break ;
        
        case "init" :
            debug_print( "TryToInitUsbx: curState='init'" ) ;
            $ret_array = run_program_at_sc_by_ssh( array(
                'program'   => "/usr/bin/python",
                'arguments' => array( $usbxcli,
                                      "sys-init" ) ) ) ;
            $retCode     = $ret_array[ 0 ] ;
            $retMsgArray = $ret_array[ 1 ] ;
            $retMsg      = join( "\n", $retMsgArray ) ;
            if( $retCode != 0 ) {
                throw new Exception( "InitUsbxFail: ret='$retCode', msg='$retMsg'" ) ;
            }
            debug_print( "InitUsbxSuccess" ) ;
            break ;
            
        default:
            throw new Exception( "UnrecognizedUsbxState: $curStateStr" ) ;
    }
    
    $curStateStr = getUsbxState( $usbxcli ) ;
    if( $curStateStr == "noimage" ) {
        throw new Exception( "" ) ;
    }
    debug_print( "UsbxCurrentState='$curStateStr'" ) ;
}

function dda_deploying_vbox() {
    global $DTASCFG_XML_FILE, $BACKEND ;
    
    $xml         = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    $usbxcli     = chop( $xml -> u_sandbox -> cli_path ) ;
    $sb_number   = chop( $xml -> sandbox -> number ) ;
    $db_host     = chop( $xml -> db -> host ) ;
    $db_user     = chop( $xml -> db -> username ) ;
    $db_password = chop( $xml -> db -> password ) ;

    
    ########################################
    # 
    ########################################
    $oriActiveImgTypeCount = 0 ;
    $lines = file( $GLOBALS[ "ORIGIN_SB_GROUP_INFO_ESXI_FILE" ] ) ;
    foreach( $lines as $line ) {
        if( trim( $line ) == "" ) continue ;
        $oriActiveImgTypeCount++ ;
    }
    $oriSandboxCount = ( $oriActiveImgTypeCount == 0 ) ? 0 : $sb_number / $oriActiveImgTypeCount ;
    debug_print( "Original active image type count: $oriActiveImgTypeCount" ) ;
    debug_print( "Original sandbox count: $oriSandboxCount" ) ;
    

    $newActiveImgTypeCount = 0 ;
    $lines = file( $GLOBALS[ "NEW_SB_GROUP_INFO_ESXI_FILE" ] ) ;
    foreach( $lines as $line ) {
        if( trim( $line ) == "" ) continue ;
        $newActiveImgTypeCount++ ;
    }
    $newSandboxCount = ( $newActiveImgTypeCount == 0 ) ? 0 : $sb_number / $newActiveImgTypeCount ;
    debug_print( "New active image type count: $newActiveImgTypeCount" ) ;
    debug_print( "New sandbox count: $newSandboxCount" ) ;
    $user_msg = '';
    
    try {

        # ensure that spcd is stopped
        stopSpcd() ;
    

        # configure usbx to 'maintanence' mode
        stopUsbx( $usbxcli ) ;
    
        # get db connection
        $connection = pg_connect( "host=$db_host dbname=dtasdb user=$db_user password=$db_password" ) ;
        if( $connection === false ) {
            throw new Exception( "ConnectToDbFail: host='$db_host', user='$db_user'" ) ;
        }

        ########################################
        # ToBeRemoved
        ########################################
        $lines = file( $GLOBALS[ "NEW_SB_GROUP_TO_BE_REMOVED_FILE" ] ) ;
        foreach( $lines as $sb_vmpath ) {
            if( ( $sb_vmpath = trim( $sb_vmpath ) ) == "" ) continue ;

            # remove
            $uuid = getSandboxImageTypeUid( $connection, $sb_vmpath ) ;
            debug_print( "RemoveSandbox: vmpath='$sb_vmpath', uuid=$uuid" ) ;
            $ret_array = run_program_at_sc_by_ssh( array(
                'program'   => "/usr/bin/python",
                'arguments' => array( $usbxcli,
                                      "sbxgrp-delete",
                                      "--id", $uuid ) ) ) ;
            $retCode      = $ret_array[ 0 ] ;
            $stdoutMsgAry = $ret_array[ 1 ] ;
            $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
            if( $retCode != 0 ) {
                $stderrMsgAry = $ret_array[ 2 ] ;
                $stderrMsg    = join( "\n", $stderrMsgAry ) ;
                throw new Exception( "DeleteUsbxGroupFail: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
            }
            debug_print( "DeleteUsbxGroupSuccess: $stdoutMsg" ) ;
        }
        
    
        ########################################
        # ToBeKept (Adjust number of sandbox)
        ########################################
        $sbVmpathToUid = array() ;
        $lines = file( $GLOBALS[ "NEW_SB_GROUP_TO_BE_KEPT_FILE" ] ) ;
        foreach( $lines as $sb_vmpath ) {
            if( ( $sb_vmpath = trim( $sb_vmpath ) ) == "" ) continue ;
            
            # get uuid
            $uuid = getSandboxImageTypeUid( $connection, $sb_vmpath ) ;

            # adjust
            debug_print( "ModifySandbox: vmpath=$sb_vmpath, uuid=$uuid, number=$newSandboxCount" ) ;
            $ret_array = run_program_at_sc_by_ssh( array(
                'program'   => "/usr/bin/python",
                'arguments' => array( $usbxcli,
                                      "sbxgrp-modify",
                                      "--id",  $uuid,
                                      "--num", $newSandboxCount ) ) ) ;
            $retCode      = $ret_array[ 0 ] ;
            $stdoutMsgAry = $ret_array[ 1 ] ;
            $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
            if( $retCode != 0 ) {
                $stderrMsgAry = $ret_array[ 2 ] ;
                $stderrMsg    = join( "\n", $stderrMsgAry ) ;
                throw new Exception( "ModifyUsbxGroupFail: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
            }
            debug_print( "ModifyUsbxGroupSuccess: msg='$stdoutMsg'" ) ;
            
            # keep this mapping
            $usbxStateInfoAry = getUsbxStateInfo( $usbxcli ) ;
            $usbxState    = $usbxStateInfoAry[ 'state' ] ;
            $usbxStateId  = $usbxStateInfoAry[ 'stateId' ] ;
            $usbxMsg      = $usbxStateInfoAry[ 'msg' ] ;
            $usbxErrCode  = $usbxStateInfoAry[ 'errCode' ] ;
            $usbxProgress = $usbxStateInfoAry[ 'progress' ] ;
            $usbxGroupUid = $usbxStateInfoAry[ 'groupUid' ] ;
            debug_print( "UsbxStateInfo: usbxState='$usbxState', usbxStateId='$usbxStateId', usbxMsg='$usbxMsg', usbxErrCode='$usbxErrCode', usbxProgress='$usbxProgress', usbxGroupUid='$usbxGroupUid'" ) ;
            
            debug_print( "KeepMapping: $sb_vmpath => $usbxGroupUid" ) ;
            $sbVmpathToUid[ "$sb_vmpath" ] = $usbxGroupUid ;
        }
    
    
        ########################################
        # ToBeAdded
        ########################################
        $lines = file( $GLOBALS[ "NEW_SB_GROUP_TO_BE_ADDED_FILE" ] ) ;
        foreach( $lines as $sb_vmpath ) {
            if( ( $sb_vmpath = trim( $sb_vmpath ) ) == "" ) continue ;
            
            # create
            debug_print( "CreateSandbox: vmpath=$sb_vmpath, number=$newSandboxCount" ) ;
            $ret_array = run_program_at_sc_by_ssh( array(
                'is_block'  => false,
                'program'   => "/usr/bin/python",
                'arguments' => array( $usbxcli,
                                      "sbxgrp-create",
                                      "--num",       $newSandboxCount,
                                      "--imagepath", $sb_vmpath ) ) ) ;
            $retCode      = $ret_array[ 0 ] ;
            $stdoutMsgAry = $ret_array[ 1 ] ;
            $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
            if( $retCode != 0 ) {
                $stderrMsgAry = $ret_array[ 2 ] ;
                $stderrMsg    = join( "\n", $stderrMsgAry ) ;
                throw new Exception( "FailToCreateUsbxGroup: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
            }
            debug_print( "CreateSandboxReturnMessage: $stdoutMsg" ) ;
            
            
            # 2013-03-13
            # There is a defect when we call usandbox cli 'sys-getstate' right after usandbox cli 'sbxgrp-create'.
            # Sleeping for a while is able to workaround it. This step can be removed after the defect is fixed.
            debug_print( "sleep 10 seconds....." ) ;
            sleep( 10 ) ;
            
            
            # check usandbox state
            # 2013-03-21 No 'timeout' exception temporarily
            $usbxGroupUid = null ;
            $retryCount    = 0 ;
            # $retryCountMax = 240 ;
            $retryCountMax = "oo" ;
            $retryInterval = 30 ;
            while( true ) {
                $usbxStateInfoAry = getUsbxStateInfo( $usbxcli ) ;
                $usbxState    = $usbxStateInfoAry[ 'state' ] ;
                $usbxStateId  = $usbxStateInfoAry[ 'stateId' ] ;
                $usbxMsg      = $usbxStateInfoAry[ 'msg' ] ;
                $usbxErrCode  = $usbxStateInfoAry[ 'errCode' ] ;
                $usbxProgress = $usbxStateInfoAry[ 'progress' ] ;
                $usbxGroupUid = $usbxStateInfoAry[ 'groupUid' ] ;
                
                debug_print( "UsbxStateInfo: usbxState='$usbxState', usbxStateId='$usbxStateId', usbxMsg='$usbxMsg', usbxErrCode='$usbxErrCode', usbxProgress='$usbxProgress', usbxGroupUid='$usbxGroupUid'" ) ;
                
                # when error occurs
                if( $usbxErrCode !== null && $usbxErrCode !== 0 ) {
                    $user_msg = UsbxErrorCodeManager::getErrorDesc( $usbxErrCode ) ;
                    throw new Exception( "CreateSandboxFail: usbxErrCode='$usbxErrCode', msg='$usbxMsg'" ) ;
                }
                
                elseif( $usbxState === 'noimage' ) {
                    throw new Exception( "UnexpectedUsbxState: usbxState='$usbxState'" ) ;
                }
                
                if( $usbxState === 'maintenance' ) {
                    break ;
                }

                debug_print( "Sleep $retryInterval seconds..." ) ;
                sleep( $retryInterval ) ;
                
                $retryCount++ ;
                // if( $retryCount > $retryCountMax ) {
                    // throw new Exception( "WaitForUsbxToBeMaintenanceModeTimeout" ) ;
                // }
                
                debug_print( "retry($retryCount/$retryCountMax)..." ) ;
            }

            # extracting sbxGrpUid
            // $usbxGroupUid = getSbxGrpUidByUsbxState( $usbxcli ) ;
            debug_print( "GetUsbxGroupUid=$usbxGroupUid" ) ;
            
            
            # testing
            // $usbxGroupUid = "0B3D9B2C6C9318A9" ;
            
            
            # keep this mapping
            debug_print( "KeepMapping: $sb_vmpath => $usbxGroupUid" ) ;
            $sbVmpathToUid[ "$sb_vmpath" ] = $usbxGroupUid ;
        }
    
    
        ########################################
        # Write Sandbox Group Info To Database
        ########################################
        
        # get Usandbox group information list
        $ret_array = run_program_at_sc_by_ssh( array(
            'program'   => "/usr/bin/python",
            'arguments' => array( $usbxcli,
                                  "sbxgrp-list" ) ) ) ;
        $retCode      = $ret_array[ 0 ] ;
        $stdoutMsgAry = $ret_array[ 1 ] ;
        $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
        if( $retCode != 0 ) {
            $stderrMsgAry = $ret_array[ 2 ] ;
            $stderrMsg    = join( "\n", $stderrMsgAry ) ;
            throw new Exception( "FailToGetGroupListFromUsbx: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
        }
        debug_print( "SuccessToGetGroupListFromUsbx: stdoutMsg='$stdoutMsg'" ) ;
        
        # parsing JSON code
        $sbGroupInfoArray = json_decode( $stdoutMsg, true ) ;
        if( $sbGroupInfoArray === NULL ) {
            throw new Exception( "FailToParseMsgFromUsbxToJson: msgFromUsbx=$stdoutMsg" ) ;
        }

        
        ########################################
        # write to database
        ########################################
        
        # testing
        // $sbVmpathToUid[ "/vmfs/volumes/4f466f15-738f1baa-394d-1803734d3a9e/DDA_Sandbox_XP/DDA_Sandbox_XP.vmx" ] = "0B3D9B2C6C9318A9" ;

        foreach( $sbVmpathToUid as $sb_vmpath => $sb_uid ) {
            
            # get usbxGroup by uuid
            if( ( $sbGroup = getSandboxGroupInfo( $sbGroupInfoArray[ "SandboxGroup" ], $sb_uid ) ) === null ) {
                $msg = "FailToGetUsbxGroupInfo: sb_uid='$sb_uid'" ;
                debug_print( $msg ) ;
                throw new Exception( $msg ) ;
            }
            

            # extract usbxGroupInfo
            $appsArray  = $sbGroup[ "Applications" ] ;
            // foreach( $appsArray as $appName ) {
                // debug_print( $appName ) ;
                // var_dump( $appName ) ;
            // }
            
            $sbxesArray = $sbGroup[ "Sandboxes" ] ;
            // foreach( $sbxesArray as $sbxArray ) {
                // foreach( $sbxArray as $item => $value ) {
                    // echo "\"$item\": \"$value\"\n" ;
                // }
            // }
            
            $name         = $sbGroup[ "Name" ] ;
            $cleaned      = $sbGroup[ "Cleaned" ] ;
            $failedReason = $sbGroup[ "FailedReason" ] ;
            $platform     = $sbGroup[ "Platform" ] ;
            $status       = $sbGroup[ "Status" ] ;
            $type         = $sbGroup[ "Type" ] ;
            
            $costTime   = $sbGroup[ "CostTime" ] ;
            $importTime = $sbGroup[ "ImportTime" ] ;
            $updateTime = $sbGroup[ "UpdateTime" ] ;


            # get Sandbox Image Type ID
            $sb_image_type_id = getSandboxImageTypeId( $connection, $sb_vmpath ) ;
            

            # already exists =>
            #    1 - delete 'configuration.image_type.image_%.sandboxes.*'
            #    2 - update "isActive" and "uid"
            if( $sb_image_type_id !== 0 ) {
                debug_print( "SandboxExistInDB: $sb_vmpath" ) ;
                $prefix = "configuration.image_type.image_$sb_image_type_id" ;
                
                # delete 'configuration.image_type.image_%.sandboxes.*'
                $keyToBeDeleted = "$prefix.sandboxes.%" ;
                debug_print( "DeleteKeyFromDB: key='$keyToBeDeleted'" ) ;
                if( pg_query_params(
                    $connection,
                    "DELETE FROM tb_global_setting WHERE key LIKE $1",
                    array( $keyToBeDeleted ) ) == false ) {

                    throw new Exception( "DeleteKeyFromDbFail: key='$keyToBeDeleted', Error=" . pg_last_error() ) ;
                }
                
                # some image_type info needs to be updated
                $data_to_be_updated = array(
                    "$prefix.isActive"        => "1",
                    "$prefix.image_type_uuid" => $sb_uid,
                    "$prefix.costtime"        => $costTime,
                    "$prefix.importtime"      => $importTime,
                    "$prefix.updatetime"      => $updateTime, ) ;
                    
                foreach( $data_to_be_updated as $key => $value ) {
                    if( pg_query_params(
                        $connection,
                        "UPDATE tb_global_setting SET value=$1 WHERE key=$2",
                        array( $value, $key ) ) == false ) {

                        throw new Exception( "UpdateKeyToDBFail: key='$key', value='$value', Error='" . pg_last_error() . "'" ) ;
                    }
                    
                    debug_print( "Update database: '$key'='$value'" ) ;
                }
                
                # some sbxGroup info needs to be re-inserted
                $data_to_be_inserted = array(
                     "$prefix.sandboxes.count" => count( $sbxesArray ) ) ;
                     
                foreach( $sbxesArray as $index => $sbxArray ) {
                    foreach( $sbxArray as $item => $value ) {
                        $tmp = $index + 1 ;
                        $data_to_be_inserted[ "$prefix.sandboxes.sandboxes_$tmp.$item" ] = $value ;
                    }
                }
                foreach( $data_to_be_inserted as $key => $value ) {
                    if( pg_query_params(
                        $connection,
                        "INSERT INTO tb_global_setting VALUES($1,$2)",
                        array( $key, $value ) ) == false ) {

                        throw new Exception( "InsertKeyToDBFail: key=$key, value=$value, Error='" . pg_last_error() . "'" ) ;
                    }
                    
                    debug_print( "Update database: '$key'='$value'" ) ;
                }

                debug_print( "Update database done." ) ;
            }
            
            else {
                debug_print( "SandboxNotExistInDB: $sb_vmpath" ) ;
                
                # get max sandbox image type id
                $max_sb_type_id = getMaxSandboxImageTypeId( $connection ) ;
                debug_print( "MaxSbImagesTypeId: ${max_sb_type_id}" ) ;
                
                $max_sb_type_id += 1 ;
                debug_print( "GetNewSandboxImagesTypeId: $max_sb_type_id" ) ;

                $prefix = "configuration.image_type.image_$max_sb_type_id" ;
                $data_to_be_inserted = array(
                    "$prefix.id"       => $max_sb_type_id,
                    "$prefix.isActive" => "1",
                    "$prefix.name"     => basename( $sb_vmpath, ".vmx" ),
                    "$prefix.path"     => $sb_vmpath,
                    "$prefix.path_vix" => getSandboxImagePathVix( $sb_vmpath ),
                    "$prefix.admin_username" => "administrator",
                    "$prefix.admin_password" => "111111",
                    
                    "$prefix.image_type_uuid" => $sb_uid,
                    "$prefix.cleaned"         => $cleaned,
                    "$prefix.failedreason"    => $failedReason,
                    "$prefix.platform"        => $platform,
                    "$prefix.status"          => $status,
                    "$prefix.type"            => $type,
                    "$prefix.costtime"        => $costTime,
                    "$prefix.importtime"      => $importTime,
                    "$prefix.updatetime"      => $updateTime,
                    "$prefix.applications.count" => count( $appsArray ),
                    "$prefix.sandboxes.count"    => count( $sbxesArray ) ) ;

                $confidential_data_key_list = array(
                    "$prefix.admin_username",
                    "$prefix.admin_password",
                );
                    
                foreach( $appsArray as $index => $appName ) {
                    $tmp = $index + 1 ;
                    $data_to_be_inserted[ "$prefix.applications.application_$tmp" ] = $appName ;
                }
                
                foreach( $sbxesArray as $index => $sbxArray ) {
                    foreach( $sbxArray as $item => $value ) {
                        $tmp = $index + 1 ;
                        $data_to_be_inserted[ "$prefix.sandboxes.sandboxes_$tmp.$item" ] = $value ;
                    }
                }
                
                foreach( $data_to_be_inserted as $key => $value ) {
                    if( pg_query_params(
                        $connection,
                        "INSERT INTO tb_global_setting VALUES($1,$2)",
                        array( $key, $value ) ) == false ) {

                        throw new Exception( "InsertKeyToDBFail: key=$key, value=$value, Error=" . pg_last_error() ) ;
                    }
                    if (in_array($key ,$confidential_data_key_list)) $value = '<hidden>';
                    debug_print( "Insert database: '$key'='$value'" ) ;
                }
                debug_print( "Insert database done" ) ;
            }
        }
        
        ########################################
        # configure usbx to 'running' mode
        ########################################
        startUsbx( $usbxcli ) ;

        
        ########################################
        # launch spcd
        ########################################
        startSpcd() ;
        
        # 2013-03-13
        # The initial status of service 'spcd' will be stopped and 'chkconfig off spcd'. We need to start it after deploying is done.

        # chkconfig on spcd
        $ret_array = run_program_at_sc_by_ssh( array(
            'program'   => "/sbin/chkconfig",
            'arguments' => array( "spcd", "on" ) ) ) ;
        $retCode      = $ret_array[ 0 ] ;
        $stdoutMsgAry = $ret_array[ 1 ] ;
        $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
        if( $retCode != 0 ) {
            $stderrMsgAry = $ret_array[ 2 ] ;
            $stderrMsg    = join( "\n", $stderrMsgAry ) ;
            throw new Exception( "ChkconfigSpcdOnFail: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
        }
        debug_print( "ChkconfigSpcdOnSuccess: stdoutMsg='$stdoutMsg'" ) ;

        # clean up
        if( $connection !== false ) {
            pg_close( $connection ) ;
        }
    }
    
    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        if( empty($user_msg) ) $user_msg = $msg;
        shm_print_error( $user_msg ) ;
        debug_print( "Exception caught: $msg" ) ;
        if( $connection !== false ) {
            pg_close( $connection ) ;
        }
        
        exit( 1 ) ;
    }
    
    return ;
}

dda_deploying_vbox();
